/*
 * Based on "CS000911 - Controlling vibra settings using CHWRMVibra". 
 */

#ifndef __VIBRO_H__
#define __VIBRO_H__

#include <e32base.h>
#include <HWRMVibra.h>

class CVibraController: public CBase, public MHWRMVibraObserver
{
public:
    static CVibraController* NewL();

    ~CVibraController();

    void VibraReserveL();
    void VibraReserveL(TBool aRestoreState, TBool aForceNoCCoeEnv);

    void VibraStartL();
    void VibraStartL(TInt aDuration, TInt aIntensity);
    void VibraReleaseL();
    void VibraStopL();

    CHWRMVibra::TVibraModeState VibraSettings();
    CHWRMVibra::TVibraStatus VibraStatus();
private:
    void ConstructL();

    // from MHWRMVibraObserver
    virtual void VibraModeChanged(CHWRMVibra::TVibraModeState aState);
    virtual void VibraStatusChanged(CHWRMVibra::TVibraStatus aStatus);

private:
    CHWRMVibra* iVibra;
};

#endif // __VIBRO_H__

// End of File
