/*
 * Based on original sprite.h from Graphics example (S60 SDK). 
 * Copyright (c) 2004 - 2006 Nokia Corporation.
 */

#include "Sprite.h"

// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CSprite::CSprite()
// C++ default constructor can NOT contain any code, that might leave.
// -----------------------------------------------------------------------------
//
CSprite::CSprite( TInt aXVelocity,
                  TInt aYVelocity,
                  const TPoint& aInitialPosition,
                  CFbsBitmap* aImage,
                  CFbsBitmap* aMask )
:   iPosition( aInitialPosition ),
    iXVelocity( aXVelocity ),
    iYVelocity( aYVelocity ),
    iImage(aImage),
    iMask(aMask)
    {
    // No implementation required
    }

// -----------------------------------------------------------------------------
// CSprite::NewL()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CSprite* CSprite::NewL( TInt aXVelocity,
                        TInt aYVelocity,
                        const TPoint& aInitialPosition,
                        CFbsBitmap* aImage,
                        CFbsBitmap* aMask )
    {
    CSprite* self = NewLC( aXVelocity,aYVelocity,aInitialPosition,aImage,aMask );
    CleanupStack::Pop( self );
    return self;
    }

// -----------------------------------------------------------------------------
// CSprite::NewLC()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CSprite* CSprite::NewLC( TInt aXVelocity,
                         TInt aYVelocity,
                         const TPoint& aInitialPosition,
                         CFbsBitmap* aImage,
                         CFbsBitmap* aMask )
    {
    CSprite* self = new ( ELeave ) CSprite( aXVelocity,
                                            aYVelocity,
                                            aInitialPosition,
                                            aImage,
                                            aMask );
    CleanupStack::PushL( self );
    self->ConstructL();
    return self;
    }

// -----------------------------------------------------------------------------
// CSprite::~CFocusEventDocument()
// Destructor.
// -----------------------------------------------------------------------------
//
CSprite::~CSprite()
    {
    // No implementation required
    }

// -----------------------------------------------------------------------------
// CSprite::ConstructL()
// Symbian 2nd phase constructor can leave.
// -----------------------------------------------------------------------------
//
void CSprite::ConstructL()
    {
    // No implementation required
    }

void CSprite::SetPosition( TPoint aPosition )
{
    iPosition = aPosition;
}

// End of File
