/*
 * Based on "CS000911 - Controlling vibra settings using CHWRMVibra". 
 */

#include "vibro.h"

CVibraController* CVibraController::NewL()
{
    CVibraController* self = new (ELeave) CVibraController();
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop(self);
    return self;
}

void CVibraController::ConstructL()
{
    iVibra = CHWRMVibra::NewL(this);
}

CVibraController::~CVibraController()
{
    delete iVibra;
}

void CVibraController::VibraReserveL()
{
    iVibra->ReserveVibraL();
}

void CVibraController::VibraReserveL(TBool aRestoreState, TBool aForceNoCCoeEnv)
{
    iVibra->ReserveVibraL(aRestoreState, aForceNoCCoeEnv);
}

void CVibraController::VibraStartL()
{
    TInt intensity(50);
    TInt duration(500);
    iVibra->StartVibraL(duration, intensity);
}

void CVibraController::VibraStartL(TInt aDuration, TInt aIntensity)
{
    iVibra->StartVibraL(aDuration, aIntensity);
}

void CVibraController::VibraReleaseL()
{
    //Release Vibra
    iVibra->ReleaseVibra();
}

void CVibraController::VibraStopL()
{
    //Stop Vibra
    iVibra->StopVibraL();
}

CHWRMVibra::TVibraModeState CVibraController::VibraSettings()
{
    //return value alternatives:
    //EVibraModeUnknown, EVibraModeON, EVibraModeOFF
    return iVibra->VibraSettings();
}

CHWRMVibra::TVibraStatus CVibraController::VibraStatus()
{
    //return value alternatives:
    //EVibraStatusUnknown, EVibraStatusNotAllowed, 
    //EVibraStatusStopped, EVibraStatusOn
    return iVibra->VibraStatus();
}

void CVibraController::VibraModeChanged(CHWRMVibra::TVibraModeState aState)
{
    switch (aState)
    {
    case CHWRMVibra::EVibraModeUnknown:
    {
        // EVibraModeUnknown do something...  
        break;
    }
    case CHWRMVibra::EVibraModeON:
    {
        // EVibraModeON do something...  
        break;
    }
    case CHWRMVibra::EVibraModeOFF:
    {
        // EVibraModeOFF do something...  
        break;
    }
    default:
    {
        // Vibra mode undefined do something...  
        break;
    }
    }
}

void CVibraController::VibraStatusChanged(CHWRMVibra::TVibraStatus aStatus)
{
    switch (aStatus)
    {
    case CHWRMVibra::EVibraStatusUnknown:
    {
        // EVibraStatusUnknown do something...            	
        break;
    }
    case CHWRMVibra::EVibraStatusNotAllowed:
    {
        // EVibraStatusUnknown do something...
        break;
    }
    case CHWRMVibra::EVibraStatusStopped:
    {
        // EVibraStatusUnknown do something...
        break;
    }
    case CHWRMVibra::EVibraStatusOn:
    {
        // EVibraStatusUnknown do something...
        break;
    }
    default:
    {
        // Vibra status undefined do something...           
        break;
    }
    }
}

// End of File
