/*  game.h
 *
 *  Main game routines
 *
 *  (c) 2009 Anton Olkhovik <ant007h@gmail.com>
 *
 *  This file is part of SymbiMaze (port of Mokomaze) - labyrinth game.
 *
 *  SymbiMaze is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  SymbiMaze is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with SymbiMaze.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GAME_H__
#define __GAME_H__

#include <e32base.h>
#include "types.h"
#include "vibro.h"

//#define DEBUG_ENGINE

#define GRAV_CONST 9.8*1.5
#define FRICT_COEF 0.10 //0.12 //0.20
#define TIME_QUANT 1.9 //1.8
#define SPEED_TO_PIXELS 0.05*1.5
#define FORCE_TREASURE 0.030 //0.040 //0.055
#define BUMP_COEF 0.3

#define GAME_STATE_NORMAL 1
#define GAME_STATE_FAILED 2
#define GAME_STATE_WIN 3

#define MAX_BUMP_SPEED 210.0
#define MIN_BUMP_SPEED 70

#define MAX_TRUEDIR_STEPS 5
#define MAX_PHYS_ITERATIONS 10

#define VIBRATION_TIME 15 //10 //20

class CSymbiMazeAppView;

class CGame : public CBase
    {
    public: // Constructors and destructors
        static CGame* NewL(CSymbiMazeAppView* aAppView);
        static CGame* NewLC(CSymbiMazeAppView* aAppView);
        virtual ~CGame();

    public:
		TReal getacx, getacy;
		void InitVibro();
        void StopVibro();
		
		TReal fabs(TReal x);
		TReal sqrt(TReal x);
		TReal cos(TReal x);
		TReal asin(TReal x);
		bool InRect(int px,int py, int x,int y,int w,int h);
		void BumpVibrate(TReal speed);
		void post_phys_res(TReal x, TReal y, TReal mm_vx, TReal mm_vy);
		void post_temp_phys_res(TReal x, TReal y, TReal mm_vx, TReal mm_vy);
		void apply_temp_phys_res();
		void tout();
		TReal calcdist(TReal x1,TReal y1, TReal x2,TReal y2);
		TReal calclen(TReal x, TReal y);
		DPoint normalize(DPoint p);
		int inbox(TReal x, TReal y, Box box);
		int incircle(TReal x, TReal y, TReal cx, TReal cy, TReal cr);
		int edgebump(int tx,int ty, TReal x,TReal y, TReal mm_vx,TReal mm_vy);
		int testbump(TReal x,TReal y, TReal mm_vx,TReal mm_vy);
		int line(TReal x0, TReal y0, TReal x1, TReal y1, TReal vx0,TReal vy0, TReal vx1,TReal vy1);
		void InitState();
		void MoveBall(TReal x, TReal y);		

    	Config qt_game_config;
    	Level *qt_game_levels; //[MAX_LEVELS];
    	int qt_game_levels_count;
    	int cur_level;
    	int game_state;
		
    	TReal px,py;
    	TReal prev_px, prev_py;
    	
    	TInt hole_x, hole_y;
    	
    private: // Constructors
    	CGame(CSymbiMazeAppView* aAppView);
        void ConstructL();

    private:
//    	TReal px,py;
    	TReal vx,vy;
    	TReal pr_px, pr_py;
    	TReal pr_vx, pr_vy;
    	 
//    	TReal prev_px, prev_py;
    	 
    	int new_game_state;
    	
    	TReal tmp_px, tmp_py;
    	TReal tmp_vx, tmp_vy;
    	
    	CVibraController *iVibra;
    	CSymbiMazeAppView *iAppView;
    };

#endif // __GAME_H__

// End of File
