#ifndef __SYMBIMAZEDOCUMENT_H__
#define __SYMBIMAZEDOCUMENT_H__

// INCLUDES
#include <eikdoc.h>

// FORWARD DECLARATIONS
class CSymbiMazeAppUi;
class CEikApplication;

// CLASS DECLARATION

/**
* CSymbiMazeDocument application class.
* An instance of class CSymbiMazeDocument is the Document part of the AVKON
* application framework for the SymbiMazeDocument application.
*/
class CSymbiMazeDocument : public CEikDocument
    {
    public: // Constructors and destructor

        /**
        * NewL.
        * Two-phased constructor.
        * Construct a CSymbiMazeDocument for the AVKON application aApp.
        * Using two phase construction, and return a pointer
        * to the created object.
        * @param aApp Application creating this document.
        * @return A pointer to the created instance of CSymbiMazeDocument.
        */
        static CSymbiMazeDocument* NewL( CEikApplication& aApp );

        /**
        * NewLC.
        * Two-phased constructor.
        * Construct a CSymbiMazeDocument for the AVKON application aApp.
        * Using two phase construction, and return a pointer
        * to the created object.
        * @param aApp Application creating this document.
        * @return A pointer to the created instance of CSymbiMazeDocument.
        */
        static CSymbiMazeDocument* NewLC( CEikApplication& aApp );

        /**
        * ~CSymbiMazeDocument
        * Virtual Destructor.
        */
        virtual ~CSymbiMazeDocument();

    private: // Constructors

        /**
        * ConstructL
        * 2nd phase constructor.
        */
        void ConstructL();

        /**
        * CSymbiMazeDocument.
        * C++ default constructor.
        * @param aApp Application creating this document.
        */
        CSymbiMazeDocument( CEikApplication& aApp );

    private: // Functions from base classes

        /**
        * From CEikDocument, CreateAppUiL.
        * Create a CSymbiMazeAppUi object and return a pointer to it.
        * @return A pointer to the created instance of the AppUi created.
        */
        CEikAppUi* CreateAppUiL();
    };

#endif // __SYMBIMAZEDOCUMENT_H__
