/*  types.h
 *
 *  Often used types definition
 *
 *  (c) 2009 Anton Olkhovik <ant007h@gmail.com>
 *
 *  This file is part of SymbiMaze (port of Mokomaze) - labyrinth game.
 *
 *  SymbiMaze is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  SymbiMaze is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with SymbiMaze.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TYPES_H
#define TYPES_H
 
#include <e32base.h>

//#define MAX_LEVELS 100
//#define MAX_BOXES 600
//#define MAX_HOLES 200
#define MAX_FINS 1

typedef struct {
 
TReal x;
TReal y;
 
} DPoint;
 
typedef struct {
 
int x;
int y;
 
} Point;
 
typedef struct {
 
int x1;
int y1;
 
int x2;
int y2;
 
} Box;
 
typedef struct {
 
int wnd_w;
int wnd_h;
 
int ball_r;
int hole_r;
         
} Config;
 
typedef struct {
 
int boxes_count;
Box *boxes; //[MAX_BOXES];
 
int holes_count;
Point *holes; //[MAX_HOLES];
 
int fins_count;
Point fins[MAX_FINS];
 
Point init;
 
} Level;
 
#endif /* TYPES_H */
