/*
 * Based on original sensorexampledatalistener.h from SensorExample (S60 SDK). 
 * Copyright (c) 2007, 2008 Nokia Corporation.
 */

#include <sensrvchannel.h>
#include <sensrvtappingsensor.h>
#include "sensordatalistener.h"
#include "SymbiMazeAppView.h"


// -----------------------------------------------------------------------------
// CSensorDataListener::NewL()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CSensorDataListener* CSensorDataListener::NewL( CSymbiMazeAppView* aAppView )
    {
    return new ( ELeave ) CSensorDataListener( aAppView );
    }

// -----------------------------------------------------------------------------
// CSensorDataListener::CSensorDataListener()
// C++ default constructor can NOT contain any code, that might leave.
// -----------------------------------------------------------------------------
//
CSensorDataListener::CSensorDataListener( CSymbiMazeAppView* aAppView )
    : iAppView( aAppView ),
    scaleK(1)
    {
    // No implementation required
    }

// -----------------------------------------------------------------------------
// CSensorDataListener::~CSensorDataListener()
// Destructor.
// -----------------------------------------------------------------------------
//
CSensorDataListener::~CSensorDataListener()
    {
    // No implementation required
    }

// -----------------------------------------------------------------------------
// CSensorDataListener::DataReceived
// New data is available in the receiving buffer.
// -----------------------------------------------------------------------------
//
void CSensorDataListener::DataReceived( CSensrvChannel& aChannel,
                                        TInt /*aCount*/,
                                        TInt /*aDataLost*/ )
    {
    TSensrvChannelInfo info = aChannel.GetChannelInfo();

    if( info.iChannelType == KSensrvChannelTypeIdAccelerometerXYZAxisData )
        {
        TSensrvAccelerometerAxisData accData;
        TPckg<TSensrvAccelerometerAxisData> accPackage( accData );
        aChannel.GetData( accPackage );
        iAppView->AccelerometerData( accData.iAxisX * scaleK, accData.iAxisY * scaleK );
        }    
    }

// -----------------------------------------------------------------------------
// CSensorDataListener::DataReceived
// Data listening failed.
// -----------------------------------------------------------------------------
//
void CSensorDataListener::DataError( CSensrvChannel& /*aChannel*/,
                                     TSensrvErrorSeverity /*aError*/ )
    {
    }

// -----------------------------------------------------------------------------
// CSensorDataListener::GetDataListenerInterfaceL
// Get supported interface.
// -----------------------------------------------------------------------------
//
void CSensorDataListener::GetDataListenerInterfaceL( 
    TUid /*aInterfaceUid*/, TAny*& aInterface )
    {
    // Set interface as NULL to indicate only default interface currently supported.
    // If new interface(s) is being introduced and application wants to support that
    // aInterfaceUid must be checked and aInterface set accordingly.
    aInterface = NULL;
    }

// -----------------------------------------------------------------------------

void CSensorDataListener::SetScaleK( TReal x )
    {
    scaleK = x;
    }
