#include <avkon.hrh>
#include <aknnotewrappers.h>
#include <stringloader.h>
#include <SymbiMaze.rsg>

#include <sensrvaccelerometersensor.h>
#include <sensorexample.rsg> //defines
#include <sensrvchannelfinder.h>
#include <sensrvchannel.h>
#include "sensordatalistener.h"

#include "SymbiMaze.pan"
#include "SymbiMazeAppUi.h"
#include "SymbiMazeAppView.h"
#include "SymbiMaze.hrh"

// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CSymbiMazeAppUi::CSymbiMazeAppUi()
// C++ default constructor can NOT contain any code, that might leave.
// -----------------------------------------------------------------------------
//
CSymbiMazeAppUi::CSymbiMazeAppUi()
    {
    // No implementation required
    }

// -----------------------------------------------------------------------------
// CSymbiMazeAppUi::ConstructL()
// Symbian 2nd phase constructor can leave.
// -----------------------------------------------------------------------------
//
void CSymbiMazeAppUi::ConstructL()
    {
    BaseConstructL(EAknEnableSkin | EAppOrientationPortrait);

    iAppView = CSymbiMazeAppView::NewL( ClientRect() );
    
	iDataListener = CSensorDataListener::NewL( iAppView );
	TRAPD( err , 
		   OpenChannelL( iAccelerometerChannel, 
						 KSensrvChannelTypeIdAccelerometerXYZAxisData ) );
	if( KErrNone != err || !iAccelerometerChannel )
		{
		//error
		}

	AddToStackL( iAppView );
    }

// -----------------------------------------------------------------------------
// CSymbiMazeAppUi::~CSymbiMazeAppUi()
// Destructor.
// -----------------------------------------------------------------------------
//
CSymbiMazeAppUi::~CSymbiMazeAppUi()
    {
    if( iAccelerometerChannel )
	{
        iAccelerometerChannel->StopDataListening();
        iAccelerometerChannel->CloseChannel();
	}    
    delete iDataListener;
    if ( iAppView )
	{
        iEikonEnv->RemoveFromStack( iAppView );
        delete iAppView;
        iAppView = NULL;
	}
    delete iAccelerometerChannel;
    }

// -----------------------------------------------------------------------------
// CSymbiMazeAppUi::HandleCommandL()
// Takes care of key event handling.
// -----------------------------------------------------------------------------
//
void CSymbiMazeAppUi::HandleCommandL( TInt aCommand )
    {
    switch( aCommand )
        {
        case EEikCmdExit:
        case EAknSoftkeyExit:
            iAppView->PrepToQuit();
            iAppView->SaveState();
            Exit();
            break;

        case ESymbiMazePlay:
            iAppView->StartGame();
            break;

        case ESymbiMazePause:
            iAppView->StopGame();
            break;

        case ESymbiMazeNext:
        	iAppView->NextLevel();
            break;

        case ESymbiMazePrev:
        	iAppView->PrevLevel();
            break;

        case ESymbiMazeReset:
        	iAppView->ResetLevel();
            break;

        case ESymbiMazeHelp:
            iAppView->ShowHelpDlg();
            break;
            
        case ESymbiMazeAbout:
            iAppView->ShowAboutDlg();
            break;
            
        default:
            break;
        }
    }

//******************************************************************************

void CSymbiMazeAppUi::HandleForegroundEventL( TBool aForeground )
    {
    iAppView->FocusEvent(aForeground);
    CAknAppUi::HandleForegroundEventL( aForeground );
    }

void CSymbiMazeAppUi::OpenChannelL( CSensrvChannel*& aChannel,
                                   TSensrvChannelTypeId aChannelTypeId )
    {
    CSensrvChannelFinder* finder = CSensrvChannelFinder::NewLC();
    RSensrvChannelInfoList channelList;
    CleanupClosePushL( channelList );

    TSensrvChannelInfo info;
    info.iChannelType = aChannelTypeId;
    finder->FindChannelsL( channelList, info );

    if ( channelList.Count() > 0 )
        {
        info = channelList[0];

        aChannel = CSensrvChannel::NewL( info );
        aChannel->OpenChannelL();

        iDataListener->SetScaleK( 2.0 / 127 );
        aChannel->StartDataListeningL( iDataListener, 1, 1, 0 ); //1,16
        }

    channelList.Close();
    CleanupStack::Pop( &channelList );
    CleanupStack::PopAndDestroy( finder );
    }

// End of File
