/*
 * Based on original sensorexampledatalistener.h from SensorExample (S60 SDK). 
 * Copyright (c) 2007, 2008 Nokia Corporation.
 */

#ifndef SENSORDATALISTENER_H
#define SENSORDATALISTENER_H

// INCLUDES
#include <sensrvdatalistener.h>

// FORWARD DECLARATIONS
class CSymbiMazeAppView;

// CLASS DECLARATION

/**
 * Data listener implementation
 * Callback interface to indicate when new data is available.
 */
class CSensorDataListener: public CBase, public MSensrvDataListener
{
public:

    /**
     * Two-phase constructor
     */
    static CSensorDataListener* NewL(CSymbiMazeAppView* aAppView);

    /**
     * Destructor.
     */
    virtual ~CSensorDataListener();

public:

    //From MSensorDataListener
    void DataReceived(CSensrvChannel& aChannel, TInt aCount, TInt aDataLost);
    void DataError(CSensrvChannel& aChannel, TSensrvErrorSeverity aError);
    void GetDataListenerInterfaceL(TUid aInterfaceUid, TAny*& aInterface);

    void SetScaleK(TReal x);

private:

    /**
     * C++ constructor
     */
    CSensorDataListener(CSymbiMazeAppView* aAppView);

private:

    //data
    CSymbiMazeAppView* iAppView; //Not own
    TReal scaleK;
};

#endif //SENSORDATALISTENER
