#ifndef __SYMBIMAZE_APPLICATION_H__
#define __SYMBIMAZE_APPLICATION_H__

// INCLUDES
#include <aknapp.h>

// CONSTANTS

// UID for the application; this should correspond
// to the uid defined in the mmp file
#define APP_UID_STR "A000EBE7"
const TUid KUidSymbiMazeApp = { 0xA000EBE7 };

// CLASS DECLARATION

/**
 * CSymbiMazeApplication application class.
 * An instance of CSymbiMazeApplication is the application part of the AVKON
 * application framework for the CSymbiMazeApplication.
 */
class CSymbiMazeApplication: public CAknApplication
{
public:
    // from CAknApplication
    /**
     * From CApaApplication, AppDllUid.
     * @return Application's UID.
     */
    TUid AppDllUid() const;

protected:
    // Functions from base classes
    /**
     * From CApaApplication, CreateDocumentL.
     * Creates SymbiMazeApplication document object.
     * The returned pointer in not owned by the SymbiMazeApplication
     * object.
     * @return A pointer to the created document object.
     */
    CApaDocument* CreateDocumentL();
};

#endif // __SYMBIMAZE_APPLICATION_H__
// End of File
