#ifndef __SYMBIMAZEAPPUI_H__
#define __SYMBIMAZEAPPUI_H__

// INCLUDES
#include <aknappui.h>
#include <sensrvchannelinfo.h>

// FORWARD DECLARATIONS
class CSymbiMazeAppView;
class CSensrvChannel;
class CSensorDataListener;

// CLASS DECLARATION

/**
 * CSymbiMazeAppUi application UI class.
 * An instance of class CSymbiMazeAppUi is the UserInterface part of the AVKON
 * application framework for the SymbiMaze
 */
class CSymbiMazeAppUi: public CAknAppUi
{
public:
    // Constructors and destructor

    /**
     * ConstructL.
     * 2nd phase constructor.
     */
    void ConstructL();

    /**
     * CSymbiMazeAppUi.
     * C++ default constructor. This needs to be public due to
     * the way the framework constructs the AppUi
     */
    CSymbiMazeAppUi();

    /**
     * ~CSymbiMazeAppUi.
     * Virtual Destructor.
     */
    virtual ~CSymbiMazeAppUi();

    void HandleForegroundEventL(TBool aForeground); //

public:
    // Functions from base classes

    /**
     * From CEikAppUi, HandleCommandL.
     * Takes care of command handling.
     * @param aCommand Command to be handled.
     */
    void HandleCommandL(TInt aCommand);

private:
    // Data

    /**
     * iAppView
     * The application view
     * Owned by CSymbiMazeAppUi object.
     */
    CSymbiMazeAppView* iAppView;

    CSensrvChannel* iAccelerometerChannel;
    CSensorDataListener* iDataListener;

private:
    void OpenChannelL(CSensrvChannel*& aChannel,
            TSensrvChannelTypeId aChannelTypeId);
};

#endif // __SYMBIMAZEAPPUI_H__
// End of File
