/*  symbimazeappview.h
 *
 *  Rendering engine
 *
 *  (c) 2009 Anton Olkhovik <ant007h@gmail.com>
 *
 *  This file is part of SymbiMaze (port of Mokomaze) - labyrinth game.
 *
 *  SymbiMaze is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  SymbiMaze is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with SymbiMaze.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SYMBIMAZEAPPVIEW_H__
#define __SYMBIMAZEAPPVIEW_H__

// INCLUDES
#include <coecntrl.h>
#include <eikenv.h>
#include <AknIconUtils.h>

#include <remconcoreapitargetobserver.h>
#include <remconinterfaceselector.h>
#include <remconcoreapitarget.h>

#include "game.h"

#define BALL_ANIM_FRAMES 5

// FORWARD DECLARATIONS
class CIconFileProvider;

namespace
{
    _LIT ( KMultiBitmapFilename,"SymbiMazeAppImages.mbm" );
}

/**
 * CSymbiMazeAppView view class.
 * An instance of this class is the Application View object
 * for the SymbiMaze application
 */
class CSymbiMazeAppView: public CCoeControl,
        public MRemConCoreApiTargetObserver
{
public:
    // Constructors and destructor
    /**
     * NewL.
     * Two-phased constructor.
     * Create a CSymbiMazeAppView object, which will draw itself to aRect.
     * @param aRect The rectangle this view will be drawn to.
     * @return a pointer to the created instance of CSymbiMazeAppView.
     */
    static CSymbiMazeAppView* NewL(const TRect& aRect);

    /**
     * NewLC.
     * Two-phased constructor.
     * Create a CSymbiMazeAppView object, which will draw itself to aRect.
     * @param aRect Rectangle this view will be drawn to.
     * @return A pointer to the created instance of CSymbiMazeAppView.
     */
    static CSymbiMazeAppView* NewLC(const TRect& aRect);

    /**
     * ~CSymbiMazeAppView
     * Virtual Destructor.
     */
    virtual ~CSymbiMazeAppView();

public:
    // New functions

    void FocusEvent(TBool isFocused);
    void StartGame();
    void StopGame();
    void ToggleGame();
    virtual void HandlePointerEventL(const TPointerEvent& aPointerEvent);
    void AccelerometerData(TReal aX, TReal aY);
    void PrevLevel();
    void NextLevel();
    void ResetLevel();

    void PrepToQuit();
    void SaveState();
    void ShowHelpDlg();
    void ShowAboutDlg();

    virtual void MrccatoCommand(TRemConCoreApiOperationId aOperationId,
            TRemConCoreApiButtonAction aButtonAct);

private:
    // Functions from base classes

    /**
     * From CCoeControl, Draw
     * Draw this CSymbiMazeAppView to the screen.
     * @param aRect the rectangle of this view that needs updating
     */
    void Draw(const TRect& aRect) const;

    void HandleResourceChange(TInt aType, const TRect& aRect);

private:
    // Constructors

    /**
     * ConstructL
     * 2nd phase constructor.
     * Perform the second phase construction of a CSymbiMazeAppView object
     * @param aRect The rectangle this view will be drawn to.
     */
    void ConstructL(const TRect& aRect);

    /**
     * CSymbiMazeAppView.
     * C++ default constructor.
     */
    CSymbiMazeAppView();

private:
    // New functions

    /**
     * DoPeriodTask.
     * Called by period task static function.
     */
    void DoPeriodTask();

    /**
     * Period.
     * Call back function for a periodic timer
     * @param aPtr a parameter passed to the timer when the timer is started.
     * @return Value TRUE indicates the callback should be done again.
     */
    static TInt Period(TAny* aPtr);

    /**
     * UpdateDisplay.
     * Perfom the drawing, does not activate the GC.
     */
    void UpdateDisplay(TBool full) const;

    /**
     * ScaleImages
     * Scales background and sprite according to current layout.
     */
    void ScaleImages();

    TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent, TEventCode aType);
    void InitMaze();
    TInt GetInt(TPtr16 &sp);
    void ForceRedraw();
    void RenderLevel();
    void ProcessGameState();
    void ZeroAnim();
    
    void RenderWallShadow(TInt bx1, TInt by1, TInt bx2, TInt by2);
    void RenderWall(TInt x1, TInt y1, TInt x2, TInt y2);
    void OffPenEnable();
    void OffPenDisable(); 

private:
    // Data

    /**
     * iBackgroundImage
     * The background bitmap
     * Owned by CSymbiMazeAppView object.
     */
    CFbsBitmap* iBackgroundImage;

    /**
     * iOffScreenBitmap
     * The off screen bitmap
     * Owned by CSymbiMazeAppView object.
     */
    CFbsBitmap* iOffScreenBitmap;

    /**
     * iOffScreenBitmapDevice
     * The off screen bitmap device
     * Owned by CSymbiMazeAppView object.
     */
    CFbsBitmapDevice* iOffScreenBitmapDevice;

    /**
     * iOffScreenBitmapGc
     * The off screen bitmap gc
     * Owned by CSymbiMazeAppView object.
     */
    CFbsBitGc* iOffScreenBitmapGc;

    /**
     * iPeriodicTimer
     * The periodic timer used to control the animation
     * Owned by CSymbiMazeAppView object.
     */
    CPeriodic* iPeriodicTimer;

    RFs iFsSession;
    CIconFileProvider* iIconProvider;

    TRect iAppRect;
    TRect iFullRect;

    TBool game;
    CGame *maze;
    TReal scaleImg;
    TPoint shiftImg;
    TSize fieldSize;
    TInt ballr;
    TInt holer;

    CFbsBitmap* iBallAnimImage[BALL_ANIM_FRAMES];
    CFbsBitmap* iBallAnimMask[BALL_ANIM_FRAMES];
    TInt iBallAnimRad[BALL_ANIM_FRAMES];

    CFbsBitmap* iWallImage;
    CFbsBitmap* iHoleImage;
    CFbsBitmap* iHoleMask;
    CFbsBitmap* iFinImage;

    CFbsBitmap* iPauseImage;
    CFbsBitmap* iPauseMask;

    TBool saveLoaded;
    TBool saveOnE;

    CRemConInterfaceSelector* iSelector;
    CRemConCoreApiTarget* iTarget;
    TBool first_draw;

    TInt anim_stage;
    TInt anim_timer;

    TInt box_shadow_length;
    TInt box_shadow_length_scaled;

    TInt iPeriod;
};

#endif // __SYMBIMAZEAPPVIEW_H__
// End of File
