#include "SymbiMazeAppUi.h"
#include "SymbiMazeDocument.h"

// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CSymbiMazeDocument::CSymbiMazeDocument()
// C++ default constructor can NOT contain any code, that might leave.
// -----------------------------------------------------------------------------
//
CSymbiMazeDocument::CSymbiMazeDocument(CEikApplication& aApp) :
    CEikDocument(aApp)
{
    // No implementation required
}

// -----------------------------------------------------------------------------
// CSymbiMazeDocument::NewL()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//

CSymbiMazeDocument* CSymbiMazeDocument::NewL(CEikApplication& aApp)
{
    CSymbiMazeDocument* self = NewLC(aApp);
    CleanupStack::Pop();
    return self;
}

// -----------------------------------------------------------------------------
// CSymbiMazeDocument::NewLC()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CSymbiMazeDocument* CSymbiMazeDocument::NewLC(CEikApplication& aApp)
{
    CSymbiMazeDocument* self = new (ELeave) CSymbiMazeDocument(aApp);
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
}

// -----------------------------------------------------------------------------
// CSymbiMazeDocument::ConstructL()
// Symbian 2nd phase constructor can leave.
// -----------------------------------------------------------------------------
//
void CSymbiMazeDocument::ConstructL()
{
    // No implementation required
}

// -----------------------------------------------------------------------------
// CSymbiMazeDocument::~CSymbiMazeDocument()
// Destructor.
// -----------------------------------------------------------------------------
//
CSymbiMazeDocument::~CSymbiMazeDocument()
{
    // No implementation required
}

// -----------------------------------------------------------------------------
// CSymbiMazeDocument::CreateAppUiL()
// Constructs CreateAppUi.
// -----------------------------------------------------------------------------
//
CEikAppUi* CSymbiMazeDocument::CreateAppUiL()
{
    // Create the application user interface, and return a pointer to it;
    // the framework takes ownership of this object
    return (static_cast<CEikAppUi*> (new (ELeave) CSymbiMazeAppUi));
}

// End of File
